//
//  TTTManageUsersViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/30/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTUserManagerViewController.h"
#import "TTTUserManager.h"
#import "TTTUserDetailViewController.h"

@interface TTTUserManagerViewController ()


@end

@implementation TTTUserManagerViewController

    NSArray *userTableData;
    TTTUserManager* userManager=nil;
    TTTUser *selectedUser=nil;

    @synthesize exitButton;
    @synthesize userTableView;

    - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil{
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
    
        userManager  = [TTTUserManager CreateUserManager];
        userTableData = [userManager getAllUsers];
    
    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

    - (IBAction) exit:(id)sender{
        [self dismissViewControllerAnimated:YES completion:nil];
    }

    - (IBAction) showUserDetails:(id)sender{
        if (selectedUser != nil){
            [self performSegueWithIdentifier:@"ShowUserDetails" sender:self];
        }

    }

#pragma Table View Data Source methods

    - (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
        static NSString *userTableIdentifier = @"UserItem";
    
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:userTableIdentifier];
    
        if (cell == nil) {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:userTableIdentifier];
        }
    
        cell.textLabel.text = [[userTableData objectAtIndex:indexPath.row] userid];
        return cell;
    }

    - (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
        return [userTableData count];
    }

#pragma Table View Delegate methods

    - (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
        UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
        NSString *cellText = cell.textLabel.text;
        NSLog(@"Cell selected %@ Row >%d< Text: %@", indexPath, indexPath.row, cellText);
        selectedUser = [userManager getUserGivenUserid:cellText];
    }

#pragma Segue methods

-(void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender{
    NSLog(@"Segue selected %@ Identifier %@", segue, segue.identifier);
    TTTUserDetailViewController* userDetailsViewController = segue.destinationViewController;
    [userDetailsViewController setUserObject:selectedUser];
}


@end
